	clear all, close all, clc
	
	M1 = 3; M2 = 2;  
	wcT = 0.05*pi; wsT = 0.1*pi; dc = 0.1; ds = 0.001;
	Be = M1*[wcT wsT]; d = [dc ds]/2;
	wT = linspace(0,pi,1000);
	[N1, Be, D, W] = HERRMANN_LP_FIR_ORDER(Be, d); N1
	[h1, Err] = REMEZ_FIR(N1, Be, D, W, 'm');   % Model filter H1(z)
	H1 = freqz(h1,1,M1*wT); 					% Decimated filter H1 
	subplot(3,1,1),  PLOT_MAG_Z_dB(wT, H1, pi, 90, 'H_1') 
	P1 = reshape(h1,M1,length(h1)/M1)	
	d = [dc/2 ds/2]; 
	Be =  [0 wcT  2*pi/M1-wcT 2*pi/M1+wcT pi pi];
	D = [1 1 0 0 1 1]; W = [4 1 1];
	N2 = 20
	[h2, Err] = REMEZ_FIR(N2, Be, D, W, 'm');   %  Filter H2(z)
	H2 = freqz(h2,1, wT);  
	subplot(3,1,2),PLOT_MAG_Z_dB(wT, H2, pi, 90, 'H_2')
	H = H1.*H2;
	subplot(3,1,3), PLOT_MAG_Z_dB(wT, H, pi, 90, 'H') 
	h2 = [h2,0];	P2 = reshape(h2,M2,length(h2)/M2)

% Validate
	fsin = 12000; 	% Sample frequency
	x = 0.01*sin(2*pi*(1:1001)*150/fsin) + 0.01*sin(2*pi*(1:1001)*200/fsin); %	Input signal
	[X,f1] = freqz(x,1, 1000,fsin); % Spectrum of the input signal	
	figure (2), subplot(3,1,1)
	plot(f1, abs(X), 'linewidth', 2)
	ylabel(['|\itX(f_s_i_n)|'],'FontName', 'times','FontSize',16), grid on, zoom on
	% Polyphase downsampling and filtering, M1 = 3 See Figure 14.36 for the odering
	v0 = x(1:M1:length(x)); v1 = [0,x(3:M1:length(x))]; v2 = x(2:M1:length(x));
	y0 = filter(P1(1,:),1,v0); y1 = filter(P1(2,:),1,v1); y2 = filter(P1(3,:),1,v2);
	yd1 = y0 + y1 + y2; % Decimated signal
	[Yd1,f2] = freqz(yd1,1,1000,fsin/M1);
	subplot(3,1,2), plot(f2, abs(Yd1), 'linewidth', 2)
	ylabel(['|\itY(f_1)|'],'FontName', 'times','FontSize',16), grid on, zoom on
	% Polyphase decomposition, M2 = 2
	x = [yd1, 0];
	v0 = x(1:M2:length(x)); v1 = [0,x(3:M2:length(x))]; 
	y0 = filter(P2(1,:),1,v0);  y1 = filter(P2(2,:),1,v1); 
	y = y0 + y1 ; % Decimated signal
	[Y,fout] = freqz(y,1,1000,fsin/M1/M2);
	subplot(3,1,3), plot(fout, abs(Y), 'linewidth', 2),
	ylabel(['|\itY(f_o_u_t)|'],'FontName', 'times','FontSize',16),  grid on, zoom on
	xlabel('Frequency, Hz')
	
	
	
